/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.idm.trident;

import com.filenet.wcm.api.ObjectFactory;
import com.filenet.wcm.api.Properties;
import com.filenet.wcm.api.Property;
import com.filenet.wcm.api.Session;
import com.filenet.wcm.apps.server.util.prefs.WcmSitePrefs;
import com.filenet.wcm.toolkit.client.ui.WcmDlg;
import com.filenet.wcm.toolkit.client.ui.WcmDlgFactory;
import com.filenet.wcm.toolkit.client.ui.WcmDlgItem;
import filenet.vw.api.VWAttachment;
import filenet.vw.api.VWException;
import filenet.vw.api.VWSession;
import filenet.vw.base.VWString;
import filenet.vw.base.logging.Logger;
import filenet.vw.idm.toolkit.IVWIDMAttachment;
import filenet.vw.idm.toolkit.IVWIDMAuthToken;
import filenet.vw.idm.toolkit.IVWIDMDialog;
import filenet.vw.idm.toolkit.IVWIDMDocument;
import filenet.vw.idm.toolkit.IVWIDMFactory;
import filenet.vw.idm.toolkit.IVWIDMFactoryProperties;
import filenet.vw.idm.toolkit.IVWIDMItem;
import filenet.vw.idm.toolkit.IVWIDMLibrary;
import filenet.vw.idm.trident.VWIDMTridentAttachment;
import filenet.vw.idm.trident.VWIDMTridentDialog;
import filenet.vw.idm.trident.VWIDMTridentItem;
import filenet.vw.idm.trident.VWTridentFactoryProperties;
import filenet.vw.toolkit.utils.VWCommandLineArgs;
import java.applet.Applet;
import java.awt.Frame;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class VWTridentFactory
implements IVWIDMFactory {
    private static final VWString[] sa_Strings = new VWString[]{new VWString("vw.idm.trident.fileNET", "IBM FileNet Business Process Management"), new VWString("vw.idm.trident.copyrightMessage", "\\u00A9 Copyright IBM Corp. 2001, 2010. All Rights Reserved."), new VWString("vw.idm.trident.logonTitle", "Process Engine Logon"), new VWString("vw.idm.trident.productNameAdmin", "Process Administrator"), new VWString("vw.idm.trident.productNameConfig", "Process Configuration Console"), new VWString("vw.idm.trident.productNameDesigner", "Process Designer "), new VWString("vw.idm.trident.productNameTracker", "Process Tracker"), new VWString("vw.idm.trident.productNameLaunchStep", "Process Launch Step Processor"), new VWString("vw.idm.trident.productNameStepProcessor", "Process Step Processor"), new VWString("vw.idm.trident.aboutProduct", "About {0}"), new VWString("vw.idm.trident.fullProductName", "{0} {1}"), new VWString("vw.idm.trident.productNameProcessManager", "Process Engine Task Manager"), new VWString("vw.idm.trident.productNamePODesigner", "Process Simulation Designer"), new VWString("vw.idm.trident.productNamePOViewer", "Process Simulation Animator"), new VWString("vw.idm.trident.productNamePOConsole", "Process Simulation Console"), new VWString("vw.idm.trident.3rdPartyCopyrightMessage", "Licensed Materials - Property of IBM Corp. (5724-R76)  \\u00A9 Copyright IBM Corp. 2001, 2010  All Rights Reserved.  US Government Users Restricted Rights. Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp. IBM and IBM logo are registered trademarks of IBM Corp. and its affiliates in the US, other countries, or both. Java and Java-based trademarks are trademarks of Sun Microsystems, Inc. This Program is licensed under the terms of the license agreement accompanying the Program. This license agreement may be either located in a Program directory folder or library identified as \"License\" or \"Non_IBM_License\", if applicable, or provided as a printed license agreement. Please read this agreement carefully before using the Program. By using the Program, you agree to these terms."), new VWString("vw.idm.trident.repositoryName", "Object Store"), new VWString("vw.idm.trident.addWflToDMS", "Add the workflow definition to an object store"), new VWString("vw.idm.trident.addScenarioToDMS", "Add the scenario definition to an object store"), new VWString("vw.idm.trident.addStepPaletteToDMS", "Add the step palette definition to an object store"), new VWString("vw.idm.trident.addConfigurationToDMS", "Add the configuration file to an object store"), new VWString("vw.idm.trident.importWorkflowFromDMS", "Import workflow from an object store"), new VWString("vw.idm.trident.saveWflToDMS", "Save the workflow definition to an object store"), new VWString("vw.idm.trident.saveScenarioToDMS", "Save the scenario definition to an object store"), new VWString("vw.idm.trident.saveStepPaletteToDMS", "Save the step palette definition to an object store"), new VWString("vw.idm.trident.saveConfigurationToDMS", "Save the configuration file to an object store"), new VWString("vw.idm.trident.wflCheckedOutFromDMS", "The workflow definition is currently checked out from an object store"), new VWString("vw.idm.trident.scenarioCheckedOutFromDMS", "The scenario definition is currently checked out from an object store"), new VWString("vw.idm.trident.stepPaletteCheckedOutFromDMS", "The step palette definition is currently checked out from an object store"), new VWString("vw.idm.trident.configurationCheckedOutFromDMS", "The configuration file is currently checked out from an object store")};
    private static Logger logger = Logger.getLogger("filenet.vw.idm");
    private VWTridentFactoryProperties factoryProperties = null;
    private WcmDlgItem m_scope = null;
    private static final String m_className = "VWTridentFactory";

    public VWTridentFactory(Applet applet) {
        this.factoryProperties = new VWTridentFactoryProperties(applet);
    }

    public VWTridentFactory() {
        this.factoryProperties = new VWTridentFactoryProperties();
    }

    public VWTridentFactory(VWCommandLineArgs args) {
        this.factoryProperties = new VWTridentFactoryProperties(args);
    }

    protected WcmDlgItem getScope() throws Exception {
        if (this.m_scope == null) {
            WcmSitePrefs pref = this.factoryProperties.getWcmSitePrefs();
            this.m_scope = WcmDlgFactory.getEntireNetworkItem((Session)this.factoryProperties.getSession(), (WcmSitePrefs)pref);
        }
        return this.m_scope;
    }

    public IVWIDMDialog getBrowseDialog(IVWIDMItem contextItem, int browseMode, String buttonText, String libraryId) throws VWException {
        String m_method = "getBrowseDialog";
        logger.entering(m_className, m_method);
        try {
            WcmDlgItem scopeItem = null;
            WcmDlgItem directoryItem = null;
            scopeItem = this.getScope();
            if (libraryId != null) {
                scopeItem = scopeItem.getChildById(libraryId);
            }
            if (contextItem != null && contextItem instanceof VWIDMTridentItem && (directoryItem = ((VWIDMTridentItem)contextItem).getWcmDlgItem()) != null) {
                directoryItem.clearContents();
            }
            Vector<Integer> filterCollection = new Vector<Integer>();
            if ((browseMode & 1) > 0) {
                filterCollection.addElement(new Integer(1));
            }
            if ((browseMode & 2) > 0) {
                filterCollection.addElement(new Integer(2));
            }
            if ((browseMode & 4) > 0) {
                filterCollection.addElement(new Integer(-100));
            }
            if ((browseMode & 8) > 0) {
                filterCollection.addElement(new Integer(15));
            }
            int[] filterTypes = new int[filterCollection.size()];
            for (int i = 0; i < filterCollection.size(); ++i) {
                Integer filter = (Integer)filterCollection.elementAt(i);
                filterTypes[i] = filter;
            }
            WcmDlg dlg = WcmDlgFactory.getBrowseVersionDialog((WcmDlgItem)scopeItem, (WcmDlgItem)directoryItem, (String)buttonText, (int[])filterTypes);
            if ((browseMode & 0x40) > 0) {
                dlg.setBrowseMode(5);
            } else {
                dlg.setBrowseMode(1);
            }
            VWIDMTridentDialog vWIDMTridentDialog = new VWIDMTridentDialog(dlg);
            Object var13_14 = null;
            logger.exiting(m_className, m_method);
            return vWIDMTridentDialog;
        }
        catch (Exception ex) {
            try {
                throw new VWException(ex);
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                logger.exiting(m_className, m_method);
                throw throwable;
            }
        }
    }

    public IVWIDMDialog getBrowseDialog(IVWIDMItem contextItem, int browseMode, String buttonText, String libraryId, String docClass) throws VWException {
        String m_method = "getBrowseDialog " + docClass;
        logger.entering(m_className, m_method);
        try {
            WcmDlgItem scopeItem = null;
            WcmDlgItem directoryItem = null;
            scopeItem = this.getScope();
            if (libraryId != null) {
                scopeItem = scopeItem.getChildById(libraryId);
            }
            if (contextItem != null && contextItem instanceof VWIDMTridentItem && (directoryItem = ((VWIDMTridentItem)contextItem).getWcmDlgItem()) != null) {
                directoryItem.clearContents();
            }
            Vector<Integer> filterCollection = new Vector<Integer>();
            if ((browseMode & 1) > 0) {
                filterCollection.addElement(new Integer(1));
            }
            if ((browseMode & 2) > 0) {
                filterCollection.addElement(new Integer(2));
            }
            if ((browseMode & 4) > 0) {
                filterCollection.addElement(new Integer(-100));
            }
            if ((browseMode & 8) > 0) {
                filterCollection.addElement(new Integer(15));
            }
            int[] filterTypes = new int[filterCollection.size()];
            for (int i = 0; i < filterCollection.size(); ++i) {
                Integer filter = (Integer)filterCollection.elementAt(i);
                filterTypes[i] = filter;
            }
            docClass = VWTridentFactory.MapDocClassName(docClass);
            WcmDlg dlg = WcmDlgFactory.getBrowseDialog((WcmDlgItem)scopeItem, (WcmDlgItem)directoryItem, (String)buttonText, (int[])filterTypes, (String)docClass);
            if ((browseMode & 0x40) > 0) {
                dlg.setBrowseMode(5);
            } else {
                dlg.setBrowseMode(1);
            }
            VWIDMTridentDialog vWIDMTridentDialog = new VWIDMTridentDialog(dlg);
            Object var14_15 = null;
            logger.exiting(m_className, m_method);
            return vWIDMTridentDialog;
        }
        catch (Exception ex) {
            try {
                throw new VWException(ex);
            }
            catch (Throwable throwable) {
                Object var14_16 = null;
                logger.exiting(m_className, m_method);
                throw throwable;
            }
        }
    }

    public IVWIDMDialog getWFDefBrowseDialogForLink(IVWIDMItem contextItem, String buttonText, String libraryId) throws VWException {
        String m_method = "getWFDefBrowseDialogForLink:" + libraryId;
        logger.entering(m_className, m_method);
        try {
            WcmDlgItem scopeItem = null;
            WcmDlgItem directoryItem = null;
            scopeItem = this.getScope();
            if (libraryId != null) {
                scopeItem = scopeItem.getChildById(libraryId);
            }
            if (contextItem != null && contextItem instanceof VWIDMTridentItem && (directoryItem = ((VWIDMTridentItem)contextItem).getWcmDlgItem()) != null) {
                directoryItem.clearContents();
            }
            int[] filterTypes = new int[]{1160};
            WcmDlg dlg = WcmDlgFactory.getBrowseDialog((WcmDlgItem)scopeItem, (WcmDlgItem)directoryItem, (String)buttonText, (int[])filterTypes);
            dlg.setBrowseMode(1);
            VWIDMTridentDialog vWIDMTridentDialog = new VWIDMTridentDialog(dlg);
            Object var11_11 = null;
            logger.exiting(m_className, m_method);
            return vWIDMTridentDialog;
        }
        catch (Exception ex) {
            try {
                throw new VWException(ex);
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                logger.exiting(m_className, m_method);
                throw throwable;
            }
        }
    }

    public IVWIDMDialog getOpenDialog(IVWIDMItem contextItem, String buttonText) throws VWException {
        String m_method = "getOpenDialog";
        logger.entering(m_className, m_method);
        try {
            int[] filterTypes = new int[]{1};
            WcmDlgItem directoryItem = null;
            if (contextItem != null && contextItem instanceof VWIDMTridentItem && (directoryItem = ((VWIDMTridentItem)contextItem).getWcmDlgItem()) != null) {
                directoryItem.clearContents();
            }
            WcmDlg dlg = WcmDlgFactory.getBrowseDialog((WcmDlgItem)this.getScope(), directoryItem, (String)buttonText, (int[])filterTypes);
            dlg.setBrowseMode(2);
            VWIDMTridentDialog vWIDMTridentDialog = new VWIDMTridentDialog(dlg);
            Object var9_9 = null;
            logger.exiting(m_className, m_method);
            return vWIDMTridentDialog;
        }
        catch (Exception ex) {
            try {
                throw new VWException(ex);
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                logger.exiting(m_className, m_method);
                throw throwable;
            }
        }
    }

    public IVWIDMDialog getOpenDialog(IVWIDMItem contextItem, String buttonText, String docClass) throws VWException {
        String m_method = "getOpenDialog:" + docClass;
        logger.entering(m_className, m_method);
        try {
            int[] filterTypes = new int[]{1};
            WcmDlgItem directoryItem = null;
            if (contextItem != null && contextItem instanceof VWIDMTridentItem && (directoryItem = ((VWIDMTridentItem)contextItem).getWcmDlgItem()) != null) {
                directoryItem.clearContents();
            }
            docClass = VWTridentFactory.MapDocClassName(docClass);
            WcmDlg dlg = WcmDlgFactory.getBrowseDialog((WcmDlgItem)this.getScope(), (WcmDlgItem)directoryItem, (String)buttonText, (int[])filterTypes, (String)docClass);
            dlg.setBrowseMode(2);
            VWIDMTridentDialog vWIDMTridentDialog = new VWIDMTridentDialog(dlg);
            Object var10_10 = null;
            logger.exiting(m_className, m_method);
            return vWIDMTridentDialog;
        }
        catch (Exception ex) {
            try {
                throw new VWException(ex);
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                logger.exiting(m_className, m_method);
                throw throwable;
            }
        }
    }

    public IVWIDMDialog getAddDialog(Frame parent, IVWIDMItem contextItem, byte[] docContents, String docClass) throws VWException {
        return this.getAddDialog(parent, contextItem, docContents, docClass, null);
    }

    public IVWIDMDialog getAddDialog(Frame parent, IVWIDMItem contextItem, byte[] docContents, String docClass, Hashtable propertyMap) throws VWException {
        String m_method = "getAddDialog";
        logger.entering(m_className, m_method);
        try {
            WcmDlgItem directoryItem = null;
            if (contextItem != null && contextItem instanceof VWIDMTridentItem && (directoryItem = ((VWIDMTridentItem)contextItem).getWcmDlgItem()) != null) {
                directoryItem.clearContents();
            }
            String ceDocClass = VWTridentFactory.MapDocClassName(docClass);
            Properties props = this.mapProperties(propertyMap);
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, "calling WcmDlgFactory.getAddDialog, docClass=" + docClass);
            }
            WcmDlg dlg = WcmDlgFactory.getAddDialog((Frame)parent, (WcmDlgItem)this.getScope(), (WcmDlgItem)directoryItem, (InputStream)new ByteArrayInputStream(docContents), (long)(docContents == null ? 0 : docContents.length), (String)ceDocClass, (Properties)props);
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, "after calling WcmDlgFactory.getAddDialog, got the dlg..");
            }
            if (ceDocClass == "{A5C636CD-11BD-455D-9E1A-604A356ABFBA}") {
                if (docClass.equals("XPDL_WorkflowDefinition")) {
                    dlg.setMimeType("application/x-filenet-xpdlworkflowdefinition");
                } else {
                    dlg.setMimeType("application/x-filenet-workflowdefinition");
                }
            }
            if (ceDocClass == "{902C0C1F-65DC-4925-B8FA-B4ECA4AD752A}") {
                dlg.setMimeType("application/x-filenet-scenariodefinition");
            } else if (ceDocClass == "{01A3A8C2-7AEC-11D1-A31B-0020AF9FBB1C}") {
                dlg.setMimeType("text/xml");
            }
            VWIDMTridentDialog vWIDMTridentDialog = new VWIDMTridentDialog(dlg);
            Object var13_13 = null;
            logger.exiting(m_className, m_method);
            return vWIDMTridentDialog;
        }
        catch (Exception ex) {
            try {
                throw new VWException(ex);
            }
            catch (Throwable throwable) {
                Object var13_14 = null;
                logger.exiting(m_className, m_method);
                throw throwable;
            }
        }
    }

    public IVWIDMItem getIDMItem(String canonicalDocID) throws VWException {
        logger.entering(m_className, "getIDMItem, " + canonicalDocID);
        return VWIDMTridentItem.getItem(canonicalDocID);
    }

    public IVWIDMItem getIDMItemFromVWAttachment(VWAttachment vwAtt) throws VWException {
        logger.entering(m_className, "getIDMItemFromVWAttachment, " + vwAtt.toString());
        return VWIDMTridentItem.getItemFromVWAttachment(vwAtt);
    }

    public IVWIDMDocument getIDMDocument(String library, String vsId, String verDocId) throws VWException {
        return (IVWIDMDocument)((Object)VWIDMTridentItem.getItem(3, library, vsId, verDocId));
    }

    public IVWIDMLibrary getIDMLibrary(String library) throws VWException {
        return (IVWIDMLibrary)((Object)VWIDMTridentItem.getItem(1, library, null, null));
    }

    public void release() {
        if (logger.isFinest()) {
            logger.finest(m_className, "release", "Bye bye..");
        }
        this.factoryProperties = null;
    }

    public IVWIDMAttachment getAttachment(String canonicalID) throws VWException {
        return VWIDMTridentAttachment.getAttachment(canonicalID);
    }

    public void setProperties(IVWIDMFactoryProperties aFactoryProperties) {
        if (aFactoryProperties instanceof VWTridentFactoryProperties) {
            this.factoryProperties = (VWTridentFactoryProperties)aFactoryProperties;
        }
    }

    public IVWIDMFactoryProperties getProperties() {
        return this.factoryProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized VWSession getSavedVWSession() {
        String defaultRouter;
        String vwSoapServletURL;
        String m_method;
        block6: {
            m_method = "getSavedVWSession";
            logger.entering(m_className, m_method);
            vwSoapServletURL = (String)this.factoryProperties.getProperty("vwSoapServlet");
            defaultRouter = (String)this.factoryProperties.getProperty("defaultRouter");
            if (defaultRouter != null) break block6;
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, "No default router is defined.");
            }
            VWSession vWSession = null;
            Object var10_7 = null;
            logger.exiting(m_className, m_method);
            return vWSession;
        }
        try {
            String token = (String)this.factoryProperties.getProperty("token");
            String jsessionId = (String)this.factoryProperties.getProperty("sessionId");
            String routerURL = vwSoapServletURL + "?" + defaultRouter + ";" + jsessionId;
            logger.info(m_className, m_method, "routerURL=" + routerURL);
            VWSession ses = new VWSession();
            ses.logonWithToken(token, routerURL);
            logger.info(m_className, m_method, "logon SUCCESSFULLY");
            VWSession vWSession = ses;
            Object var10_8 = null;
            logger.exiting(m_className, m_method);
            return vWSession;
        }
        catch (Exception e) {
            try {
                logger.throwing(m_className, m_method, e);
                VWSession vWSession = null;
                Object var10_9 = null;
                logger.exiting(m_className, m_method);
                return vWSession;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                logger.exiting(m_className, m_method);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized VWSession getVWSession(String hostName, String port, String routerName) {
        String m_method = "getVWSession:" + hostName + ",port=" + port + ",routerName=" + routerName;
        logger.entering(m_className, m_method);
        try {
            String vwSoapServletURL = (String)this.factoryProperties.getProperty("vwSoapServlet");
            String token = (String)this.factoryProperties.getProperty("token");
            String jsessionId = (String)this.factoryProperties.getProperty("sessionId");
            String routerURL = vwSoapServletURL + "?" + routerName + ";" + jsessionId;
            logger.info(m_className, m_method, "routerURL=" + routerURL);
            VWSession ses = new VWSession();
            ses.logonWithToken(token, routerURL);
            logger.info(m_className, m_method, "Logged on SUCCESSFULLY");
            VWSession vWSession = ses;
            Object var12_13 = null;
            logger.exiting(m_className, m_method);
            return vWSession;
        }
        catch (Exception e) {
            try {
                logger.throwing(m_className, m_method, e);
                VWSession vWSession = null;
                Object var12_14 = null;
                logger.exiting(m_className, m_method);
                return vWSession;
            }
            catch (Throwable throwable) {
                Object var12_15 = null;
                logger.exiting(m_className, m_method);
                throw throwable;
            }
        }
    }

    public VWSession getVWSessionFromLDAP(Frame parent, String hostName, String[] routerNames, String[] routerPorts) throws Exception {
        return null;
    }

    public synchronized void setVWSessionToken(String userName, String password, String group, String token, String routerName) {
    }

    public synchronized IVWIDMAuthToken getVWSessionToken() {
        return null;
    }

    public synchronized IVWIDMLibrary[] getLibraries() throws VWException {
        return VWIDMTridentItem.getLibraries();
    }

    public VWString getVWString(int index) {
        if (index >= 0 && index < sa_Strings.length) {
            return sa_Strings[index];
        }
        return null;
    }

    private Properties mapProperties(Hashtable propertyMap) {
        if (propertyMap == null) {
            return null;
        }
        Properties props = ObjectFactory.getProperties();
        Enumeration e = propertyMap.keys();
        while (e.hasMoreElements()) {
            String propName = (String)e.nextElement();
            Object o = propertyMap.get(propName);
            if (o == null) continue;
            Property prop = ObjectFactory.getProperty((String)propName);
            if (o instanceof Boolean) {
                prop.setValue((Boolean)o);
            }
            if (o instanceof Integer) {
                prop.setValue((Integer)o);
            }
            if (o instanceof String) {
                prop.setValue((String)o);
            }
            if (o instanceof Date) {
                prop.setValue((Date)o);
            }
            if (o instanceof Double) {
                prop.setValue((Double)o);
            }
            props.add((Object)prop);
        }
        propertyMap.clear();
        return props;
    }

    public static String MapDocClassName(String docClass) {
        if (docClass == null) {
            return "{A5C636CD-11BD-455D-9E1A-604A356ABFBA}";
        }
        String m_method = "MapDocClassName:" + docClass;
        if (docClass.equalsIgnoreCase("ScenarioDefinition")) {
            docClass = "{902C0C1F-65DC-4925-B8FA-B4ECA4AD752A}";
        } else if (docClass.equalsIgnoreCase("Simulation")) {
            docClass = "{193E5683-C724-4C3B-8D55-F4091B9B7222}";
        } else if (docClass.equalsIgnoreCase("StepPalette") || docClass.equalsIgnoreCase("PE_Configuration")) {
            docClass = "{01A3A8C2-7AEC-11D1-A31B-0020AF9FBB1C}";
        } else if (docClass.equalsIgnoreCase("WorkflowDefinition") || docClass.equalsIgnoreCase("XPDL_WorkflowDefinition")) {
            docClass = "{A5C636CD-11BD-455D-9E1A-604A356ABFBA}";
        }
        if (logger.isFinest()) {
            logger.finest(m_className, m_method, "returning " + docClass);
        }
        return docClass;
    }
}

